<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'dbconfig.php';

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if (!$user['isAdmin']) {
    echo "Sorry, you don't have permissions to access this page.";
    exit;
}
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'vendor/autoload.php';  // Include Composer's autoloader

use Endroid\QrCode\QrCode;

include 'dbconfig.php';

$google_code = '';
$facebook_code = '';
$google_qr = '';
$facebook_qr = '';
$flyer_path = '';

function generateUniqueCode($pdo) {
    do {
        $code = bin2hex(random_bytes(10));
        $stmt = $pdo->prepare("SELECT * FROM users WHERE google_code = ? OR facebook_code = ?");
        $stmt->execute([$code, $code]);
    } while ($stmt->fetch());

    return $code;
}

function generateQRCode($uniqueCode) {
    $qrCode = new QrCode('https://svyowired.com/scan/scan.php?code=' . $uniqueCode);
    return $qrCode->writeDataUri();
}

function generateFlyer($googleQR, $facebookQR) {
    // Your flyer generation code using the two QR codes will go here.
    // For now, I will simply return a placeholder path.
    // Adjust this to your needs.
    return 'path_to_generated_flyer.jpg';
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $google_code = generateUniqueCode($pdo);
    $facebook_code = generateUniqueCode($pdo);

    $google_qr = generateQRCode($google_code);
    $facebook_qr = generateQRCode($facebook_code);

    $stmt = $pdo->prepare("INSERT INTO users (google_code, facebook_code) VALUES (?, ?)");
    $stmt->execute([$google_code, $facebook_code]);

    $flyer_path = generateFlyer($google_qr, $facebook_qr);
}

function generateFlyerWithQRCodes($google_qr, $facebook_qr, $artwork_path) {
    // Load the artwork
    $artwork = imagecreatefromjpeg($artwork_path);

    // Load the QR codes
    $google_qr_img = imagecreatefrompng($google_qr);
    $facebook_qr_img = imagecreatefrompng($facebook_qr);

    // Resize the QR codes (make them twice as big)
    $google_qr_resized = imagescale($google_qr_img, imagesx($google_qr_img) * 2, imagesy($google_qr_img) * 2);
    $facebook_qr_resized = imagescale($facebook_qr_img, imagesx($facebook_qr_img) * 2, imagesy($facebook_qr_img) * 2);

    // Define positions to overlay the QR codes onto the artwork
    $google_qr_x = 313;
    $google_qr_y = 2550;
    $facebook_qr_x = 1588;
    $facebook_qr_y = 2550;

    // Copy QR codes onto the artwork
    imagecopy($artwork, $google_qr_resized, $google_qr_x, $google_qr_y, 0, 0, imagesx($google_qr_resized), imagesy($google_qr_resized));
    imagecopy($artwork, $facebook_qr_resized, $facebook_qr_x, $facebook_qr_y, 0, 0, imagesx($facebook_qr_resized), imagesy($facebook_qr_resized));

    // Save the final image
    $output_path = "path_to_generated_flyer.jpg";
    imagejpeg($artwork, $output_path);

    // Cleanup
    imagedestroy($artwork);
    imagedestroy($google_qr_img);
    imagedestroy($facebook_qr_img);
    imagedestroy($google_qr_resized);
    imagedestroy($facebook_qr_resized);

    return $output_path;
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ... [rest of your code inside this block]

    $flyerPath = generateFlyerWithQRCodes($google_qr, $facebook_qr, 'path_to_your_artwork.jpg');
}
?>



<div class="row mt-4">
    <div class="col-md-12 text-center">
        <?php if (!empty($flyer_path)): ?>
            <a href="<?= $flyer_path ?>" target="_blank" class="btn btn-success">Generate Flyer</a>
        <?php endif; ?>
    </div>
</div>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate User</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header text-center">
                    Generate New User
                </div>
                <div class="card-body text-center">
                    <form action="test.php" method="post">
                        <button type="submit" class="btn btn-primary">Generate New User</button>
                        <a href="acshow.php" class="btn btn-secondary ml-2">List Accounts</a>
                    </form>
                    <?php
                    if (!empty($google_code) && !empty($facebook_code)):
                        $google_url = 'https://svyowired.com/scan/scan.php?code=' . $google_code;
                        $facebook_url = 'https://svyowired.com/scan/scan.php?code=' . $facebook_code;
                    ?>
                        <div class="row mt-4">
                            <!-- Google content -->
                            <div class="col-md-6 text-center">
                                <div>Google ID:</div>
                                <div><?= $google_code ?></div>
                                <button data-url="<?= $google_url ?>" class="btn-copy btn btn-info mt-1">Copy Link</button>
                                <img src="<?= $google_qr ?>" alt="Google QR Code" class="img-fluid mt-2" /><br>
                                <a href="<?= $google_qr ?>" download="GoogleQRCode.png" class="btn btn-success btn-sm mt-2">Download Google QR Code</a>
                            </div>

                            <!-- Facebook content -->
                            <div class="col-md-6 text-center">
                                <div>Facebook ID:</div>
                                <div><?= $facebook_code ?></div>
                                <button data-url="<?= $facebook_url ?>" class="btn-copy btn btn-info mt-1">Copy Link</button>
                                <img src="<?= $facebook_qr ?>" alt="Facebook QR Code" class="img-fluid mt-2" /><br>
                                <a href="<?= $facebook_qr ?>" download="FacebookQRCode.png" class="btn btn-success btn-sm mt-2">Download Facebook QR Code</a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Attach an event listener to the buttons
    const copyButtons = document.querySelectorAll('.btn-copy');
    copyButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            copyToClipboard(url);
        });
    });
});

function copyToClipboard(text) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    document.execCommand('copy');
    document.body.removeChild(textArea);
    alert('URL copied to clipboard!');
}
</script>

</body>
</html>
