<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Limit session duration for security
ini_set('session.cookie_lifetime', 60 * 60); // 1 hour
ini_set('session.gc_maxlifetime', 60*60);   // 1 hour

include 'dbconfig.php';

session_start();

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $retype_password = $_POST['retype_password'];
    $company = $_POST['company_name'];
    $google_link = $_POST['google_link'];
    $facebook_link = $_POST['facebook_link'];
    $code = $_GET['code'];

    if ($password !== $retype_password) {
        $error = 'Passwords do not match.';
    } elseif (!preg_match('/^(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{7,15}$/', $password)) {
        $error = 'Password does not meet the requirements.';
    } else {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET name=?, email=?, password=?, company_name=?, google_link=?, facebook_link=?, registered=TRUE WHERE google_code=? OR facebook_code=?");
        $stmt->execute([$name, $email, $hashed_password, $company, $google_link, $facebook_link, $code, $code]);

        header("Location: index.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-background {
            background-image: url('dot_background.php');
            background-size: cover;
        }
        .refresh-button {
            width: 30px;
            height: 30px;
            font-size: 0; /* Remove spacing around the text */
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .refresh-button span {
            font-size: 20px;
        }
    </style>
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header text-center">
                    Registration Form
                </div>
                <div class="card-body form-background">
                    <form action="register.php?code=<?php echo $_GET['code']; ?>" method="post">
<div class="form-group">
    <label for="name">Name:</label>
    <input type="text" class="form-control" id="name" name="name" required>
</div>

<div class="form-group">
    <label for="email">Email:</label>
    <input type="email" class="form-control" id="email" name="email" required>
</div>

<div class="form-group">
    <label for="password">Password:</label>
    <input type="password" class="form-control" id="password" name="password" required pattern="^(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{7,15}$" title="Must contain at least one number and one uppercase letter, one special symbol, and be between 7 and 15 characters.">
</div>

<div class="form-group">
    <label for="retype_password">Retype Password:</label>
    <input type="password" class="form-control" id="retype_password" name="retype_password" required>
</div>

<div class="form-group">
    <label for="company_name">Company Name:</label>
    <input type="text" class="form-control" id="company_name" name="company_name" required>
</div>


                        <div class="form-group">
                            <label for="google_link">Google URL:</label>
                            <input type="url" class="form-control" id="google_link" name="google_link">
                        </div>

                        <div class="form-group">
                            <label for="facebook_link">Facebook URL:</label>
                            <input type="url" class="form-control" id="facebook_link" name="facebook_link">
                        </div>

                        <div class="form-group text-center">
                            <img id="captcha-image" src="captcha2.php" alt="Captcha Image">
                            <button type="button" class="btn btn-primary refresh-button" onclick="refreshCaptcha()"><span>⟳</span></button>
                        </div>
                        <div class="form-group">
                            <label for="captcha">Enter Captcha:</label>
                            <input type="text" class="form-control" name="captcha" required>
                        </div>
                        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

                        <div class="text-center">
                            <input type="submit" value="Register" class="btn btn-primary">
                        </div>
                    </form>
                    <?php
                    if (!empty($error)) {
                        echo "<div class='alert alert-danger mt-3'>$error</div>";
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script type="text/javascript">
    function refreshCaptcha() {
        var img = document.getElementById('captcha-image');
        img.src = 'captcha2.php?' + new Date().getTime();
    }
</script>
</body>
</html>
