<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Limit session duration for security
ini_set('session.cookie_lifetime', 60 * 60); // 1 hour
ini_set('session.gc_maxlifetime', 60*60);   // 1 hour

include 'dbconfig.php';

session_start();

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];
    $csrf_token = $_POST['csrf_token'];
    $captcha = $_POST['captcha'];

    // Check for CSRF token match
    if (!hash_equals($_SESSION['csrf_token'], $csrf_token)) {
        die("Invalid request!");
    }

    // Verify the CAPTCHA
    if (isset($_SESSION['vcode']) && $captcha !== $_SESSION['vcode']) {
        $error = "Captcha is incorrect!";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            // Bind session to user's IP and User Agent
            $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
            $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];

            $_SESSION['user_id'] = $user['id'];
            header("Location: profile.php");
            exit;
        } else {
            $error = "Invalid credentials!";
        }
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <!-- Linking Bootstrap CSS for styling -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<style>
    /* Setting the background of the form to the generated dot background image */
    .form-background {
        background-image: url('dot_background.php');
        background-size: cover;
    }
    /* Styling the button to have a fixed size, and centering the refresh icon within it */
    .fixed-button {
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    /* Adjusting the font size and line height of the refresh icon */
    .fixed-button span {
        font-size: 50px;
        line-height: 0.7;  /* Adjusted line height to center the icon vertically */
    }
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-background {
            background-image: url('dot_background.php');
            background-size: cover;
        }
        .refresh-button {
            width: 30px;
            height: 30px;
            font-size: 0; /* Remove spacing around the text */
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .refresh-button span {
            font-size: 20px;
        }
    </style>
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header text-center">
                    Login
                </div>
                <div class="card-body form-background">
                    <form action="login.php" method="post">
                        <div class="form-group">
                            <label for="email">Email:</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Password:</label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                        <div class="form-group text-center">
                            <img id="captcha-image" src="captcha2.php" alt="Captcha Image">
                            <!-- Updated button class and span styles -->
                            <button type="button" class="btn btn-primary refresh-button" onclick="refreshCaptcha()"><span>⟳</span></button>
                        </div>
                        <div class="form-group">
                            <label for="captcha">Enter Captcha:</label>
                            <input type="text" class="form-control" name="captcha" required>
                        </div>
                        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                        <div class="text-center">
                            <input type="submit" class="btn btn-primary" value="Login">
                        </div>
                    </form>
                    <?php
                    if (!empty($error)) {
                        echo "<div class='alert alert-danger mt-3'>$error</div>";
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script type="text/javascript">
    function refreshCaptcha() {
        var img = document.getElementById('captcha-image');
        img.src = 'captcha2.php?' + new Date().getTime();
    }
</script>
</body>
</html>
