<?php
	session_start();

	$len = mt_rand(5, 7); // Captchat Lenght
	$paddingArr = array('5' => 30, '6' => 20, '7' => 10); // Captcha Padding Array by Len
	$padding = $paddingArr[$len]; // Captcha Start Padding
	$width = 160; // Captcha Width
	$height = 60; // Captcha Height
	$fonts = array('fonts/ttf/Vera.ttf', 'fonts/ttf/VeraMono.ttf', 'fonts/ttf/VeraSe.ttf'); // Fonts Array

	$image = imagecreatetruecolor($width, $height) or died("Cannot create canvas"); // Create Canvas

	$white = imagecolorallocate($image, 255, 255, 255);
	$black = imagecolorallocate($image, 0, 0, 0);
	
	imagefill($image, 0, 0, $white); // Add White Background
	// imagerectangle($image, 0, 0, $width - 0, $height - 0, $black); // Add Border

	genShapes($image, 10, $width, $height, 'LINES'); // Generate Lines Shapes
	genShapes($image, 200, $width, $height, 'DOTS'); // Generate Dots Shapes
	
	$string = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'; // Characters to Generate Random Code

	$code = '';

	for ($i = 1; $i <= $len; $i++) {
		$text = $string[mt_rand(0, (strlen($string) - 1))]; // Get Random Character
		imagettftext($image, mt_rand(20, 26), mt_rand(-20, 20), $padding, 40, getColor($image), $fonts[mt_rand(0, 2)], $text); // Add Character to Captcha Code

		$code = $code.$text; // Concat Current Character to Code
		$padding += 20; // Add 20 to Current Padding
	}

	$_SESSION['vcode'] = $code; // Set Session Code
	
	header("content-type: image/png"); // Set Page Header to Image
	imagepng($image); // Show Image
	imagedestroy($image); // Destroy Image
	
	/*ob_start();
    imagepng($image);
    $imgData = ob_get_clean();
    imagedestroy($image);
    echo '<img src="data:image/png;base64,'.base64_encode($imgData).'" />';*/

	function getColor($image) {
		return imagecolorallocate($image, rand(0,255), rand(0,255), rand(0,255));
	}

	function genShapes($image, $count, $width, $height, $type) {
		for ($i = 1; $i <= $count; $i++) {
			if ($type == 'LINES') {
				imageline($image, rand() % 90, rand() % 90, rand() % 90, rand() % 90, getColor($image));
			} else {
				imagesetpixel($image, mt_rand(2, $width), mt_rand(2, $height), getColor($image)); // Generate Random Dots
			}
		}
	}
?>