<?php
include 'dbconfig.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $company = $_POST['company_name'];
    $google_link = $_POST['google_link'];
    $facebook_link = $_POST['facebook_link'];

    $stmt = $pdo->prepare("UPDATE users SET name=?, email=?, company_name=?, google_link=?, facebook_link=? WHERE id=?");
    $stmt->execute([$name, $email, $company, $google_link, $facebook_link, $_SESSION['user_id']]);

    header("Location: profile.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header text-center">
                    User Profile
                </div>
                <div class="card-body">
                    <form action="profile.php" method="post">
                        <div class="form-group">
                            <label>Name:</label>
                            <input type="text" class="form-control" name="name" value="<?php echo $user['name']; ?>">
                        </div>
                        <div class="form-group">
                            <label>Email:</label>
                            <input type="email" class="form-control" name="email" value="<?php echo $user['email']; ?>">
                        </div>
                        <div class="form-group">
                            <label>Company Name:</label>
                            <input type="text" class="form-control" name="company_name" value="<?php echo $user['company_name']; ?>">
                        </div>
                        <div class="form-group">
                            <label>Google URL:</label>
                            <input type="url" class="form-control" name="google_link" value="<?php echo $user['google_link']; ?>">
                        </div>
                        <div class="form-group">
                            <label>Facebook URL:</label>
                            <input type="url" class="form-control" name="facebook_link" value="<?php echo $user['facebook_link']; ?>">
                        </div>
                        <div class="form-group text-center">
                            <input type="submit" class="btn btn-primary" value="Update Profile">
                            <a href="logout.php" class="btn btn-danger ml-2">Logout</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
