<?php
session_start();

// Generate a random string
$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
$captchaText = '';
for ($i = 0; $i < 5; $i++) {
    $captchaText .= $characters[rand(0, strlen($characters) - 1)];
}

// Store the captcha value in a session for verification
$_SESSION['captcha'] = $captchaText;

header('Content-type: image/png');

// Create an image from our string
$image = imagecreatetruecolor(100, 40);
$background = imagecolorallocate($image, 255, 255, 255);
$fontColor = imagecolorallocate($image, 0, 0, 0);

imagefilledrectangle($image, 0, 0, 99, 39, $background);
imagestring($image, 5, 15, 10, $captchaText, $fontColor);

imagepng($image);
imagedestroy($image);
?>
