<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'dbconfig.php';

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if (!$user['isAdmin']) {
    echo "Sorry, you don't have permissions to access this page.";
    exit;
}
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'dbconfig.php';

$limit = 10; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $limit;

$searchTerm = "";
$sql = "SELECT * FROM users";

if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $searchTerm = "%" . $_GET['search'] . "%";  
    $sql .= " WHERE name LIKE ? OR company_name LIKE ? OR email LIKE ? OR google_code LIKE ? OR facebook_code LIKE ?";
}

$sql .= " LIMIT $start, $limit";
$stmt = $pdo->prepare($sql);

if (!empty($searchTerm)) {
    $stmt->execute([$searchTerm, $searchTerm, $searchTerm, $searchTerm, $searchTerm]);
} else {
    $stmt->execute();
}

$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare("SELECT COUNT(id) AS id FROM users");
$stmt->execute();
$userCount = $stmt->fetch(PDO::FETCH_ASSOC);
$total_pages = ceil($userCount["id"] / $limit);

if (isset($_GET['delete_id'])) {
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$_GET['delete_id']]);
    header("Location: acshow.php"); 
    exit();
}

if (isset($_GET['edit_id']) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $stmt = $pdo->prepare("UPDATE users SET name = ?, company_name = ?, email = ? WHERE id = ?");
    $stmt->execute([$_POST['name'], $_POST['company_name'], $_POST['email'], $_GET['edit_id']]);
    header("Location: acshow.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List of Accounts</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>

<div class="container mt-5">
    <h2 class="mb-4">Accounts List</h2>
    <form action="acshow.php" method="get" class="mb-4">
        <div class="input-group">
            <input type="text" name="search" class="form-control" placeholder="Search for users..." value="<?= isset($_GET['search']) ? htmlspecialchars($_GET['search']) : '' ?>">
            <div class="input-group-append">
                <button type="submit" class="btn btn-primary">Search</button>
            </div>
        </div>
    </form>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Name</th>
                <th>Company</th>
                <th>Email</th>
                <th>Google ID</th>
                <th>Facebook ID</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($users as $user): ?>
            <tr>
                <td><?= empty($user['name']) ? 'Unregistered' : htmlspecialchars($user['name']) ?></td>
                <td><?= empty($user['company_name']) ? 'Unregistered' : htmlspecialchars($user['company_name']) ?></td>
                <td><?= empty($user['email']) ? 'Unregistered' : htmlspecialchars($user['email']) ?></td>
                <td><?= empty($user['google_code']) ? 'Unregistered' : htmlspecialchars($user['google_code']) ?></td>
                <td><?= empty($user['facebook_code']) ? 'Unregistered' : htmlspecialchars($user['facebook_code']) ?></td>
                <td>
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editModal-<?= $user['id'] ?>" <?= empty($user['name']) && empty($user['company_name']) && empty($user['email']) ? 'disabled' : '' ?>>Edit</button>

                    <a href="acshow.php?delete_id=<?= $user['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this user?')">Delete</a>
                </td>
            </tr>

            <!-- Edit Modal -->
            <div class="modal fade" id="editModal-<?= $user['id'] ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editModalLabel">Edit User</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="acshow.php?edit_id=<?= $user['id'] ?>" method="post">
                            <div class="modal-body">
                                <label>Name: </label><input type="text" class="form-control" name="name" value="<?= $user['name'] ?>"><br>
                                <label>Company: </label><input type="text" class="form-control" name="company_name" value="<?= $user['company_name'] ?>"><br>
                                <label>Email: </label><input type="text" class="form-control" name="email" value="<?= $user['email'] ?>"><br>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input type="submit" class="btn btn-primary" value="Save Changes">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <ul class="pagination">
        <?php for($i=1; $i<=$total_pages; $i++): ?>
        <li class="page-item <?= ($i == $page) ? 'active' : '' ?>"><a class="page-link" href="acshow.php?page=<?= $i ?>"><?= $i ?></a></li>
        <?php endfor; ?>
    </ul>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
